#!/bin/sh

TP_MENU_OK_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_MENU_OK_RESULT_SELECT=""

TP_MENU_OK_RESULT_OK="DTAS[TUI]@{OK}"
TP_MENU_OK_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_MENU_OK_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_MENU_OK_RESULT_CODE=""

TP_MENU_OK_RESULT_MSG=""

tp_menu_ok() {
	local title="${1}"
	local text="${2}"
	local ok_label="${3}"
    local menu_list="${4}"

    #debug_print "${0}" "${LINENO}" "title: ${title}"
    #debug_print "${0}" "${LINENO}" "text: ${text}"
    #debug_print "${0}" "${LINENO}" "ok_label: ${ok_label}"
    #debug_print "${0}" "${LINENO}" "menu_list: ${menu_list}"
    
    exec 3>&1
    local ret=`sh -c "dialog \
        --backtitle    \"${CONS_BACK_TITLE}\" \
        --title        \"${title}\" \
        --ok-label     \"${ok_label}\" \
        --no-cancel    \
        --menu         \"${text}\" \
                       \"${CONS_BOX_HEIGHT}\" \
                       \"${CONS_BOX_WIDTH}\" \
                       20 \
                       ${menu_list} \
        2>&1 1>&3"; \
        case "${?}" in \
            1|255) echo "${TP_MENU_OK_RESULT_CANCEL}" ;; \
        esac`
	exec 3>&-

    
    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        "${TP_MENU_OK_RESULT_CANCEL}" )
            TP_MENU_OK_RESULT_CODE="${TP_MENU_OK_RESULT_CANCEL}"
            TP_MENU_OK_RESULT_SELECT="${TP_MENU_OK_RESULT_NULL}"
            TP_MENU_OK_RESULT_MSG=""
            return
            ;;
    esac

    TP_MENU_OK_RESULT_CODE="${TP_MENU_OK_RESULT_OK}"
    TP_MENU_OK_RESULT_SELECT="${ret}"
    TP_MENU_OK_RESULT_MSG=""
    return
}

